<?php
require_once 'includes/read_csv.php';
require_once 'includes/spin.php';
require_once 'includes/generate_menu.php';
require_once 'includes/load_files.php';
require_once 'includes/helpers.php';
require_once 'includes/render_page.php';
require_once 'includes/render_sitemap.php';
require_once 'includes/schema.php';
require_once 'includes/bank_block.php';

// Логирование запросов Googlebot
if (stripos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Googlebot') !== false) {
    $domain = $_SERVER['HTTP_HOST'];
    $url = $_SERVER['REQUEST_URI'];
    $datetime = date('Y-m-d H:i:s');
    $logLine = "$datetime\t$url\n";
    $logFile = __DIR__ . '/logs/' . $domain . '.log';

    // Создаём папку, если не существует
    if (!is_dir(__DIR__ . '/logs')) {
        mkdir(__DIR__ . '/logs', 0777, true);
    }

    file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);
}


$url = getCleanUrl();
$domainZone = getDomainZone();
$domainName = getDomainName();

// Удаление -ru/ из конца URL
if (substr($url, -strlen($domainZone) - 2) === '-' . $domainZone . '/') {
    $url = substr($url, 0, -strlen($domainZone) - 2);
}

if ($url === '') {
    $url = '/';
}

$linkPages = array_column($links, 'Page');

// Карта сайта
if ($url === 'sitemap') {
    $template = file_exists('main.htm') ? file_get_contents('main.htm') : file_get_contents('main.htm');
    echo renderSitemap($links, $domainZone, $template);
    exit;
}

// Главная и внутренние через один рендер
if (in_array($url, $linkPages)) {
    echo renderPage($links, $url, $domainName, $domainZone, $template, $headContent, $defaultText, $keysMfo);
    exit;
}

// Обработка robots.txt
if ($url === 'robots.txt') {
    header('Content-Type: text/plain');
    echo "User-agent: Googlebot\nAllow: /\n\nUser-agent: Yandex\nAllow: /";
    exit;
}

// Редирект на главную при 404
header("Location: /", true, 301);
exit;
